#include <iostream>
#include <string>
#include <queue>
#include <algorithm>

using namespace std;

struct Edge {
	int dest;
	int cap;
	int flow;
	int back;
};

int N;
vector<vector<Edge>> G;

void addEdge(int a, int b, int flow, int cap) {
	if(a == b) return;
	Edge e1{b, cap, flow, (int)G[b].size()};
	Edge e2{a, 0, -flow, (int)G[a].size()};
	G[a].push_back(e1);
	G[b].push_back(e2);
}

vector<vector<int>> L;
vector<int> K;

bool visited[4005];

void dfs(int v, int d) {
	if(v == d) return;
	if(visited[v]) return;
	visited[v] = true;
	for(Edge e : G[v]) {
		if(G[e.dest][e.back].flow == G[e.dest][e.back].cap) continue;
		dfs(e.dest, d);
	}
}

void changeFlow(int v, int i, int d) {
	G[v][i].flow += d;
	G[G[v][i].dest][G[v][i].back].flow -= d;
}

int main() {
	cin.sync_with_stdio(false);
	
	cin >> N;
	G.resize(2 * N + 2);
	L.resize(N);
	K.resize(N);
	
	for(int b = 0; b < N; ++b) {
		int cnt;
		cin >> cnt;
		L[b].resize(cnt);
		
		for(int i = 0; i < cnt; ++i) {
			cin >> L[b][i];
			--L[b][i];
		}
	}
	
	for(int b = 0; b < N; ++b) {
		cin >> K[b];
		--K[b];
	}
	
	for(int b = 0; b < N; ++b) {
		addEdge(2 * N, b, 1, 1);
	}
	for(int g = 0; g < N; ++g) {
		addEdge(N + g, 2 * N + 1, 1, 1);
	}
	
	for(int b = 0; b < N; ++b) {
		for(int g : L[b]) {
			addEdge(b, N + g, (int)(K[b] == g), 1);
		}
	}
	
	for(int b = 0; b < N; ++b) {
		changeFlow(2 * N, b, -1);
		for(int i = 0; i < G[b].size(); ++i) {
			if(G[b][i].dest == N + K[b]) changeFlow(b, i, -1);
		}
		changeFlow(N + K[b], 0, -1);
		
		fill(visited, visited + 4005, false);
		dfs(2 * N + 1, b);
		
		int cnt = 0;
		for(int g : L[b]) {
			if(visited[N + g]) ++cnt;
		}
		cout << cnt;
		for(int g : L[b]) {
			if(visited[N + g]) cout << ' ' << g + 1;
		}
		cout << "\n";
		
		changeFlow(2 * N, b, 1);
		for(int i = 0; i < G[b].size(); ++i) {
			if(G[b][i].dest == N + K[b]) changeFlow(b, i, 1);
		}
		changeFlow(N + K[b], 0, 1);
	}
	
	return 0;
}
